clc, clear, %close all

[a,b]=uigetfile('*.mat','Scegli History *.mat file of type GA');
load([b a])

%% open History.mat -> check for convention property
LibI = myInterfacciaDAQ;
LibO = myOutputFile;
LibT = myTdmsReader;

 if isequal(history(end-1).pop , history(end).pop)
     history(end)=[];
 end
 LibO.GArecap(history);
 
 hasConv = isfield( history,'cc') && isstruct(history(1).cc);
 if hasConv
     cc = history(1).cc;
 end
 
%% ask related folder -> get dir
[d]=uigetdir(b,'In which main folder are related *.txt files stored?');

fileList = dir([d filesep 'Note']);
%%

num = @(str) str2double(string(str));
ss = [size(history(1).pop,1) length(history)];
for i=(1:ss(1)*ss(2))+2
    j=i-2;
    
    time(j,1) = string(regexp(fileList(i).name,'\(.*\)','match'));
    [item,gen]=ind2sub(ss,j);
    GA(j,1) = sprintf('G%d,i%d',gen,item)+"";
    
    % Leggo il file delle Note della simulazione i-esima.
    p = [fileList(i).folder filesep fileList(i).name];
    righe=importdata(p,'s'); %<- tutto il contenuto letto in righe.
    
    %Estraggo i numeri dalle righe che desidero.
    % i numeri sono caratteri che possono contenere il segno (-), (.) (%)
    CD(j,1)     = num(regexp(righe{8},'([\-(\d)\.]){2,}','match'));
    CD0(j,1)    = num(regexp(righe{4},'([\-(\d)\.]){2,}','match'));
    dL(j,1) = string(regexp(righe{5},'[\-(\d)\.]*\%','match')); %< lasciato in stringa
    U(j,1)      = num(regexp(righe{6},'([\-(\d)\.]){2,}','match'));
    A = regexp(righe{7},'([\-(\d)\.]){2,}','match');
    LCmean(j,1) = num(A{1});
    LCstd(j,1)  = num(A{2});
    
end

% Creo una mega Tabella con tutti gli individui
dCD   = CD-CD0;
delta = dCD./CD0*100;
x     = cat(1,history(:).pop);

tab   = table(time,dCD,delta,GA,CD0,CD,dL,U,LCmean,LCstd,x);
orari = datetime(time,'InputFormat','(MMM dd HH_mm_SS)');

% Trovo il campione del GA, e la simulazione associata, e i file correlati. 
% >>(c'è un +2 per via delle cartelle "." e "..")
[superBest, idx] = min( cat(1,history(:).score));
p  = [fileList(idx+2).folder filesep fileList(idx+2).name];
dd = strsplit(d,filesep);
s  = LibO.txt2struct(p,dd{end});

% Mostro tutta la simulazione completata
LibO.ReviveSym(s, 'complete',25);
LibO.plotMySym(s, 'one')
%%


figure
subplot(3,1,1)
plot(orari,CD0,'-r','DisplayName','CD_0 along time');

cc = polyfit((orari-orari(1))./hours(1),CD0-CD0(1),1);
hold on
leg =  sprintf('CD_0(t) = %.3f\\bullet hours+%.4f +CD_0(0)',cc(1),cc(2));
plot(orari, CD0(1)+polyval(cc,(orari-orari(1))./hours(1)), ':k','DisplayName',leg)

dL = 50; N=600;
legend, ylabel({'CD0 platooning'; sprintf('d/L=%d%% n=%d',dL,N)})

subplot(3,1,2)
plot( orari, delta,'-'), hold on
plot( orari(idx), delta(idx),'pr')
text(orari(idx), 20, sprintf('\\DeltaCD_{opt}=%.1f%%',min(delta)),...
    'Horiz','center')
ylabel('\DeltaCD%')

subplot(3,1,3)
plot( orari, CD0,'-r','DisplayName','CD_0'), hold on
plot( orari, CD ,'-b','DisplayName','CD')
plot( repmat(orari(idx),1,2), [CD(idx) CD0(idx)],':p',...
      'DisplayName',sprintf('\\DeltaCD_{opt}=%.3f',dCD(idx)));
legend
xlabel('time'), ylabel('forcing & platooning'), ylim([min(CD) max(CD0)]+[-1 1]*0.01)

set(gcf,'Color','w')



%%
tt=sortrows(tab,'dCD');
figure
subplot(2,2,[1 2])
yyaxis left
p1=plot(tt{:,'delta'},tt{:,'LCmean'},'--.','Displ','Mean Load Cell signal');
hold on,
ylabel('[V]'), xlabel('all tests sorted by: \DeltaCD'), legend
ax=gca; ax.XDir = 'reverse';
set(ax.YAxis(1),'Color',p1.Color)
yyaxis right
plot(tt{:,'delta'},tt{:,'LCstd'},'--.','Displ','Std Dev Load Cell signal')
ylabel('[V]')



grp = repmat([1 1 2],1,3);

for i=1:2
aa(i)=subplot(2,2,2+i);

boxplot(x(:,grp==i)), hold(aa(i), 'on')

plot(aa(i), 1:sum(grp==i), tt{1,'x'}(grp==i),'og')
end
%%
% ss = [size(history(1).pop,1) length(history)];

for i=1:size(x,2) 
    
    
    M = mean(x(:,i));
    if M > 20
       extra = [0 5]; 
    else
       extra = [0 5];
    end
    %str = {sprintf('x_{%d}_{mean}= %.2f',i,M); sprintf('x_{%d}_{best}= %.2f',i,x(idx,i))};
    str = {sprintf('x_{%d}_{best} \n%.2f',i,x(idx,i))};
    
    asciss = sum( grp(i)==grp(1:i) );
    
    text(aa(grp(i)), asciss+extra(1),aa(grp(i)).YLim(2)+0.5,str,'Horiz','center')
    
end

    
xlabel(aa(1),{'(sine wave for every channel)'})
xticklabels(aa(1),{'V_1top','V_2top','V_1side','V_2side','V_1bot','V_2bot'})
ylabel(aa(1),'Jet Signal [V]')

         
xticklabels(aa(2),{'f top Hz','f side Hz','f bot Hz'})
xlabel(aa(2),{'(sine wave for every channel)'})
ylabel(aa(2),'Frequency [Hz]')
set(gcf,'Color','w')


figure
for i=1:size(x,2)
subplot(3,3,i)
gscatter( dCD, x(:,i), (dCD<0)+(dCD<=min(dCD)*0.9), 'rbg','x.p',5,'off'), hold on
if i==1
legend('Bad Forcing', 'Neutral/Good forcing', 'Very Good forcing')
end

if rem(i,3)==0
ylabel('Frequency [Hz]')
else
ylabel('Voltage [V]')    
end
xlabel('\DeltaCD')
title("x_"+i+" distribution")
end
set(gcf,'Color','w')
%%
fff=figure('Color','w');
space = 3;
lim = {[5.5 9.5],[0.01 50]};
for i=1:length(lim)
   lim{i} = linspace( lim{i}(1),lim{i}(2), space+1); 
end

for i=1:length(dCD)
    for j=1:size(x,2)
    jj{j} = find( lim{grp(j)}<= x(i,j), 1,'last');
    end

    asciss(i) = sub2ind(repmat(space,1,size(x,2)), jj{:});  
    str = "x: ["+strjoin( x(i,:)+"",', ')+"]";
    pk(i) = plot( asciss(i), dCD(i), '.b', 'UserData',str); hold on
    pk(i).ButtonDownFcn = @(src,evt) set(fff.Children.Title,'String',src.UserData);
    
end

[best,idx] = min(dCD);
plot( asciss(idx), dCD(idx), 'or')
text( asciss(idx), dCD(idx), 'X_{opt}','color','r')
title('GA search depth')

set(gca,'YDir','reverse'); ylabel('\DeltaCD'), xlabel('distribution of X-combination');
xticks([])
xlim([1 space^size(x,2)]), h=.17;
text( 1,              h,'\leftarrow All Low Values of X','Horiz','left')
text( space^size(x,2),h,'All High Values of X \rightarrow','Horiz','right')
